<?php
/**
 * Exchange Resets
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('exchangeresets_title',true).'</span></div>';

try {
	
	$ExchangeResets = new \Plugin\ExchangeResets\ExchangeResets();
	$exchangeList = $ExchangeResets->getExchangeList();
	
	// check character
	if(!check_value($_GET['character'])) redirect(1,'exchangeresets/characters/');
	
	// load character info
	$Character = new Character();
	$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);
	if(!is_array($AccountCharacters)) throw new Exception(lang('error_46',true));
	if(!in_array($_GET['character'], $AccountCharacters)) throw new Exception(lang('exchangeresets_error_7',true));
	$characterData = $Character->CharacterData($_GET['character']);
	
	// exchanged resets
	$exchangedResets = $ExchangeResets->getExchangedResetsFromCharacter($characterData[_CLMN_CHR_NAME_]);
	if(!check_value($exchangedResets)) {
		$exchangedResets = 0;
	}
	
	// available exchanges
	$availableExchanges = $characterData[_CLMN_CHR_RSTS_]-$exchangedResets;
	
	// Exchange Process
	if(check_value($_GET['resets'])) {
		try {
			
			$ExchangeResets->setCharacter($_GET['character']);
			$ExchangeResets->setResets($_GET['resets']);
			$ExchangeResets->exchangeResets();
			
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	echo '<h3>'.$characterData[_CLMN_CHR_NAME_].' ('.$availableExchanges.' '.lang('exchangeresets_txt_7',true).')</h3>';
	
	echo '<table class="table">';
		echo '<thead>';
			echo '<tr>';
				echo '<th>'.lang('exchangeresets_txt_4',true).'</th>';
				echo '<th>'.lang('exchangeresets_txt_5',true).'</th>';
				echo '<th></th>';
			echo '</tr>';
		echo '</thead>';
		echo '<tbody>';
			foreach($exchangeList as $resets => $reward) {
				echo '<tr>';
					echo '<td>'.$resets.'</td>';
					echo '<td>'.number_format($reward).' '.lang('exchangeresets_txt_3').'</td>';
					echo '<td><a href="'.__EXCHANGERESETS_HOME__.'exchange/character/'.$characterData[_CLMN_CHR_NAME_].'/resets/'.$resets.'" class="btn btn-primary">'.lang('exchangeresets_txt_6',true).'</a></td>';
				echo '</tr>';
			}
		echo '</tbody>';
	echo '</table>';
	
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}